function [xss,yss,sss,P,retcode] = solution_getsteadystate(GLOBALS,THETA)
% retcode = 1 means steady state found


% -- Inputs -- %
nx       = GLOBALS.nx;
ny       = GLOBALS.ny;
xss      = zeros(nx,1);
yss      = zeros(ny,1);

% -- Load Calibrated Parameters -- %
bbeta           = GLOBALS.parameters.bbeta;
rrho            = GLOBALS.parameters.rrho;
aalpha          = GLOBALS.parameters.aalpha;
eeta            = GLOBALS.parameters.eeta;
ddelta          = GLOBALS.parameters.ddelta;
oomega          = GLOBALS.parameters.oomega;
ebar            = GLOBALS.parameters.ebar;
pbar            = GLOBALS.parameters.pbar;
abar            = GLOBALS.parameters.abar;
zbar            = GLOBALS.parameters.zbar;
varphi(1)       = GLOBALS.parameters.varphi0;
varphi(2)       = GLOBALS.parameters.varphi1;
nnu(1)          = GLOBALS.parameters.nnu0;
nnu(2)          = GLOBALS.parameters.nnu1;

% -- Load Estimated Parameters -- %
iiota           = THETA(GLOBALS.parm_ind.iiota);
pphi            = THETA(GLOBALS.parm_ind.pphi);
rbar            = THETA(GLOBALS.parm_ind.rbar);
rrhoa           = THETA(GLOBALS.parm_ind.rrhoa);
rrhoz           = THETA(GLOBALS.parm_ind.rrhoz);
rrhop           = THETA(GLOBALS.parm_ind.rrhop);
rrhor           = THETA(GLOBALS.parm_ind.rrhor);
rrhoe           = THETA(GLOBALS.parm_ind.rrhoe);
rrhod           = THETA(GLOBALS.parm_ind.rrhod);
ssigmaa       = THETA(GLOBALS.parm_ind.ssigmaa);
ssigmaz       = THETA(GLOBALS.parm_ind.ssigmaz);
ssigmap       = THETA(GLOBALS.parm_ind.ssigmap);
ssigmar       = THETA(GLOBALS.parm_ind.ssigmar);
ssigmae       = THETA(GLOBALS.parm_ind.ssigmae);
ssigmad       = THETA(GLOBALS.parm_ind.ssigmad);

% Load Estimated or Calibrated Parameters -- %
try
    kkappa          = THETA(GLOBALS.parm_ind.kkappa);
    ppsir           = GLOBALS.parameters.ppsir;
    bbar            = GLOBALS.parameters.bbar;
catch
    kkappa          = GLOBALS.parameters.kkappa;
    ppsir           = THETA(GLOBALS.parm_ind.ppsir);
    bbar            = THETA(GLOBALS.parm_ind.bbar);
end
try
    ggamma00        = log(GLOBALS.parameters.p01/(1-GLOBALS.parameters.p01));
    ggamma10        = log(GLOBALS.parameters.p10/(1-GLOBALS.parameters.p10));
catch
    ggamma00        = log(THETA(GLOBALS.parm_ind.p01)/(1-THETA(GLOBALS.parm_ind.p01)));
    ggamma10        = log(THETA(GLOBALS.parm_ind.p10)/(1-THETA(GLOBALS.parm_ind.p10)));
end

try
    ggamma01        = exp(THETA(GLOBALS.parm_ind.loggamma01));
    ggamma11        = exp(THETA(GLOBALS.parm_ind.loggamma11));
catch
    ggamma01        = exp(GLOBALS.parameters.loggamma01);
    ggamma11        = exp(GLOBALS.parameters.loggamma11);
end

% -- Transition Matrix Initial Guess -- %
P = [0.5 0.5; 0.5 0.5];
   
check = Inf;
iteration = 0;
while check > 1e-10 && iteration < 500
    iteration = iteration + 1;
    P0 = P;
    
    % -- Perturbation Point -- %
    sss         = FRWZ_ergodicdist(P);
    varphibar   = varphi*sss;

   
    
    % --  In Levels -- %
    [bss,fval] = fsolve(@(x) bss_solver(x,ebar,pbar,abar,zbar,rbar,kkappa,aalpha,eeta,pphi,bbeta,ddelta,oomega,rrho,ppsir,bbar,varphibar),0,optimset('Display','Off','TolFun',1e-20));
    bss = real(bss);
    
    ass         = abar;
    pss         = pbar;
    zss         = zbar;
    dss         = 1;
    qss         = 1;
    rss         = rbar + ppsir*(exp(bbar-bss)-1);
    OMEGAv      = (1 + pphi*rss + (1 - bbeta*(1 + rss)*zss^-rrho)*pphi*(1 + rss))/(1 - aalpha - eeta);
    OMEGAh      = (pphi*(rss + (1 - bbeta*(1 + rss)*zss^-rrho)*(1 + rss)) + 1)/aalpha;
    OMEGAk      = (((1 - (1 - bbeta*(1 + rss)*zss^-rrho)*kkappa)/bbeta/zss^-rrho - 1 + ddelta)/eeta);
    wss         = ((ass*zss^aalpha/(OMEGAk^eeta*OMEGAh^aalpha*(pss*OMEGAv)^(1 - aalpha - eeta)))^(1/(aalpha)));
    hss         = wss^(1/(oomega-1));
    vss         = OMEGAh/OMEGAv*wss/pss*hss;
    outss       = OMEGAh*hss*wss - pss*vss;
    ess         = ebar;
    kss         = OMEGAh/OMEGAk*wss*hss;
    invss       = (zss - 1 + ddelta)*kss;
    k1ss        = kss;
    css         = OMEGAh*hss*wss - (1 + pphi*rss)*pss*vss - pphi*rss*wss*hss - ess*outss - invss + bss - bss*zss/(1+rss);
    mmuss       = (css - hss^oomega/oomega)^-rrho;
    llambdass   = (1 - bbeta*(1 + rss)*zss^-rrho)*mmuss;
    bstarss     = 1/(1 + rss)*bss*zss - pphi*(1 + rss)*(wss*hss + pss*vss) + kkappa*kss*zss;
    bratioss    = bss*zss/outss;
    caratioss   = (zss - 1)*bss/outss;
    tbratioss   = (outss - ess*outss - css - invss)/outss;
    efpbss      = llambdass/bbeta/mmuss/zss^(-rrho);
    

    % -- Output -- %
    xss(1)  = log(kss);
    xss(2)  = bss;
    xss(3)  = log(ass);
    xss(4)  = log(zss);
    xss(5)  = log(pss);
    xss(6)  = rbar;
    xss(7)  = log(ess);
    xss(8)  = 0;
    yss(1)  = log(css);
    yss(2)  = log(hss);
    yss(3)  = log(vss);
    yss(4)  = log(invss);
    yss(5)  = log(k1ss);
    yss(6)  = rss;
    yss(7)  = log(qss);
    yss(8)  = log(wss);
    yss(9)  = log(mmuss);
    yss(10) = llambdass + 10^-15;
    yss(11) = bstarss;
    yss(12) = log(outss);
    yss(13) = bratioss;
    yss(14) = caratioss;
    yss(15) = tbratioss;
    yss(16) = efpbss;

    % -- Update Transiiton Matrix -- %
    P = [1-exp(ggamma00-ggamma01*bstarss)/(1+exp(ggamma00-ggamma01*bstarss))          exp(ggamma00-ggamma01*bstarss)/(1+exp(ggamma00-ggamma01*bstarss));...
           exp(ggamma10-ggamma11*llambdass)/(1+exp(ggamma10-ggamma11*llambdass))    1-exp(ggamma10-ggamma11*llambdass)/(1+exp(ggamma10-ggamma11*llambdass))];
    check = norm(P-P0);

end

if check > 1e-10
    %disp(['Steady State not Found, norm = ' num2str(check)]);
    retcode = 0;
else
    if abs(fval) > 1e-6
        %disp(['Inaccurate steady state, solved to ' num2str(fval)]); 
        retcode = 0;   
    else
        retcode = 1;
    end

end

end

function f = bss_solver(x,ebar,pbar,abar,zbar,rbar,kkappa,aalpha,eeta,pphi,bbeta,ddelta,oomega,rrho,ppsir,bbar,varphibar)
    bss         = x(1);
    
    ass         = abar;
    pss         = pbar;
    zss         = zbar;
    dss         = 1;
    qss         = 1;
    rss         = rbar + ppsir*(exp(bbar-bss)-1);
    OMEGAv      = (1 + pphi*rss + (1 - bbeta*(1 + rss)*zss^-rrho)*pphi*(1 + rss))/(1 - aalpha - eeta);
    OMEGAh      = (pphi*(rss + (1 - bbeta*(1 + rss)*zss^-rrho)*(1 + rss)) + 1)/aalpha;
    OMEGAk      = (((1 - (1 - bbeta*(1 + rss)*zss^-rrho)*kkappa)/bbeta/zss^-rrho - 1 + ddelta)/eeta);
    wss         = ((ass*zss^aalpha/(OMEGAk^eeta*OMEGAh^aalpha*(pss*OMEGAv)^(1 - aalpha - eeta)))^(1/(aalpha)));
    hss         = wss^(1/(oomega-1));
    vss         = OMEGAh/OMEGAv*wss/pss*hss;
    outss       = OMEGAh*hss*wss - pss*vss;
    ess         = ebar;
    kss         = OMEGAh/OMEGAk*wss*hss;
    invss       = (zss - 1 + ddelta)*kss;
    k1ss        = kss;
    css         = OMEGAh*hss*wss - (1 + pphi*rss)*pss*vss - pphi*rss*wss*hss - ess*outss - invss + bss - bss*zss/(1+rss);
    mmuss       = (css - hss^oomega/oomega)^-rrho;
    llambdass   = (1 - bbeta*(1 + rss)*zss^-rrho)*mmuss;
    bstarss     = 1/(1 + rss)*bss*zss - pphi*(1 + rss)*(wss*hss + pss*vss) + kkappa*kss*zss;
    bratioss    = bss*zss/outss;
    caratioss   = (zss - 1)*bss/outss;
    tbratioss   = (outss - ess*outss - css - invss)/outss;
    efpbss      = llambdass/bbeta/mmuss/zss^(-rrho);
    f(1) = varphibar*bstarss - (1-varphibar)*llambdass;

end
